/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.dialogs;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.git.core.github.IGithubRepository;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.dialogs.Messages;
import com.aptana.theme.ThemePlugin;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePullRequestDialog
extends StatusDialog {
    private Text bodyText;
    private String body;
    private Text titleText;
    private String title;
    private String baseBranch;
    private String head;
    private IGithubRepository baseRepo;
    private Combo baseBranchCombo;
    private Combo baseRepoCombo;
    private Set<IGithubRepository> repos;

    public CreatePullRequestDialog(Shell parentShell, String defaultTitle, String defaultBody, IGithubRepository defaultRepo, Set<IGithubRepository> repos, String head) {
        super(parentShell);
        this.setTitle(Messages.CreatePullRequestDialog_Title);
        this.title = defaultTitle;
        this.body = defaultBody;
        this.head = head;
        this.repos = repos;
        this.baseRepo = defaultRepo;
        this.baseBranch = this.baseRepo.getDefaultBranch();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite overview = new Composite(composite, 0);
        overview.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(5).create());
        Label icon = new Label(overview, 0);
        icon.setImage(GitUIPlugin.getImage("icons/obj16/pull_request.gif"));
        Color lightBlue = ThemePlugin.getDefault().getColorManager().getColor(new RGB(209, 227, 237));
        this.baseRepoCombo = new Combo(overview, 12);
        this.baseRepoCombo.setFont(JFaceResources.getTextFont());
        this.baseRepoCombo.setBackground(lightBlue);
        List names = CollectionsUtil.map(this.repos, (IMap)new IMap<IGithubRepository, String>(){

            public String map(IGithubRepository item) {
                return item.getFullName();
            }
        });
        this.baseRepoCombo.setItems(names.toArray(new String[names.size()]));
        this.baseRepoCombo.setText(this.baseRepo.getFullName());
        this.baseRepoCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String repoOwnerAndName = CreatePullRequestDialog.this.baseRepoCombo.getText();
                CreatePullRequestDialog.this.baseRepo = (IGithubRepository)CollectionsUtil.find((Collection)CreatePullRequestDialog.this.repos, (IFilter)new IFilter<IGithubRepository>(){

                    public boolean include(IGithubRepository item) {
                        return item.getFullName().equals(repoOwnerAndName);
                    }
                });
                CreatePullRequestDialog.this.baseBranch = CreatePullRequestDialog.this.baseRepo.getDefaultBranch();
                Set branches = CreatePullRequestDialog.this.baseRepo.getBranches();
                CreatePullRequestDialog.this.baseBranchCombo.setItems(branches.toArray(new String[branches.size()]));
                CreatePullRequestDialog.this.baseBranchCombo.setText(CreatePullRequestDialog.this.baseBranch);
            }
        });
        this.baseBranchCombo = new Combo(overview, 12);
        this.baseBranchCombo.setFont(JFaceResources.getTextFont());
        this.baseBranchCombo.setBackground(lightBlue);
        this.baseBranchCombo.setItems(new String[]{this.baseBranch});
        this.baseBranchCombo.setText(this.baseBranch);
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                Set branches = CreatePullRequestDialog.this.baseRepo.getBranches();
                CreatePullRequestDialog.this.baseBranchCombo.setItems(branches.toArray(new String[branches.size()]));
                CreatePullRequestDialog.this.baseBranchCombo.setText(CreatePullRequestDialog.this.baseBranch);
            }
        });
        this.baseBranchCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreatePullRequestDialog.this.baseBranch = CreatePullRequestDialog.this.baseBranchCombo.getText();
            }
        });
        Label ellipsis = new Label(overview, 64);
        ellipsis.setText(" ... ");
        ellipsis.setFont(JFaceResources.getTextFont());
        ellipsis.setEnabled(false);
        Label headLabel = new Label(overview, 64);
        headLabel.setText(this.head);
        headLabel.setFont(JFaceResources.getTextFont());
        headLabel.setBackground(lightBlue);
        Label titleLabel = new Label(composite, 64);
        titleLabel.setText(Messages.CreatePullRequestDialog_TitleFieldLabel);
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        titleLabel.setLayoutData((Object)data);
        titleLabel.setFont(parent.getFont());
        this.titleText = new Text(composite, 2052);
        this.titleText.setText(this.title);
        this.titleText.setLayoutData((Object)new GridData(768));
        this.titleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreatePullRequestDialog.this.title = CreatePullRequestDialog.this.titleText.getText();
                CreatePullRequestDialog.this.validate();
            }
        });
        Label label = new Label(composite, 0);
        label.setText(Messages.CreatePullRequestDialog_BodyFieldLabel);
        this.bodyText = new Text(composite, 2818);
        this.bodyText.setText(this.body);
        GridDataFactory.fillDefaults().hint(400, 300).applyTo((Control)this.bodyText);
        this.bodyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreatePullRequestDialog.this.body = CreatePullRequestDialog.this.bodyText.getText();
                CreatePullRequestDialog.this.validate();
            }
        });
        return composite;
    }

    public String getBody() {
        return this.body;
    }

    public String getTitle() {
        return this.title;
    }

    protected void validate() {
        if (StringUtil.isEmpty((String)this.title)) {
            this.updateStatus((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.CreatePullRequestDialog_EmptyTitleErrMsg));
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    public String getBaseBranch() {
        return this.baseBranch;
    }

    public IGithubRepository getBaseRepo() {
        return this.baseRepo;
    }
}

